/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.structures;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.betterx.bclib.api.v2.levelgen.structures.StructureNBT;
import org.betterx.bclib.api.v2.levelgen.structures.StructurePlacementType;
import org.betterx.bclib.util.BlocksHelper;

public class StructureWorldNBT
extends StructureNBT {
    public static final Codec<StructureWorldNBT> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)class_2960.field_25139.fieldOf("location").forGetter(cfg -> cfg.location), (App)Codec.INT.fieldOf("offset_y").orElse((Object)0).forGetter(cfg -> cfg.offsetY), (App)StructurePlacementType.CODEC.fieldOf("placement").orElse((Object)StructurePlacementType.FLOOR).forGetter(cfg -> cfg.type), (App)Codec.FLOAT.fieldOf("chance").orElse((Object)Float.valueOf(1.0f)).forGetter(cfg -> Float.valueOf(cfg.chance))).apply((Applicative)instance, StructureWorldNBT::new));
    public final StructurePlacementType type;
    public final int offsetY;
    public final float chance;
    private static final Map<String, StructureWorldNBT> READER_CACHE = Maps.newHashMap();

    protected StructureWorldNBT(class_2960 location, int offsetY, StructurePlacementType type, float chance) {
        super(location);
        this.offsetY = offsetY;
        this.type = type;
        this.chance = chance;
    }

    public static StructureWorldNBT create(class_2960 location, int offsetY, StructurePlacementType type) {
        return StructureWorldNBT.create(location, offsetY, type, 1.0f);
    }

    public static StructureWorldNBT create(class_2960 location, int offsetY, StructurePlacementType type, float chance) {
        String key = location.toString() + "::" + offsetY + "::" + type.method_15434();
        return READER_CACHE.computeIfAbsent(key, r -> new StructureWorldNBT(location, offsetY, type, chance));
    }

    public boolean generateIfPlaceable(class_5425 level, class_2338 pos, class_5819 random) {
        return this.generateIfPlaceable(level, pos, StructureWorldNBT.getRandomRotation(random), StructureWorldNBT.getRandomMirror(random));
    }

    public boolean generateIfPlaceable(class_5425 level, class_2338 pos, class_2470 r, class_2415 m) {
        if (this.canGenerate((class_1936)level, pos, r)) {
            return this.generate(level, pos, r, m);
        }
        return false;
    }

    public boolean generate(class_5425 level, class_2338 pos, class_2470 r, class_2415 m) {
        return this.generateCentered(level, pos.method_10086(this.offsetY), r, m);
    }

    protected boolean canGenerate(class_1936 level, class_2338 pos, class_2470 rotation) {
        if (this.type == StructurePlacementType.FLOOR) {
            return this.canGenerateFloor(level, pos, rotation);
        }
        if (this.type == StructurePlacementType.LAVA) {
            return this.canGenerateLava(level, pos, rotation);
        }
        if (this.type == StructurePlacementType.UNDER) {
            return this.canGenerateUnder(level, pos, rotation);
        }
        if (this.type == StructurePlacementType.CEIL) {
            return this.canGenerateCeil(level, pos, rotation);
        }
        return false;
    }

    private boolean containsBedrock(class_1936 level, class_2338 startPos) {
        for (int i = 0; i < this.structure.method_15160().method_10264(); i += 2) {
            if (!level.method_8320(startPos.method_10086(i)).method_27852(class_2246.field_9987)) continue;
            return true;
        }
        return false;
    }

    protected boolean canGenerateFloorFreeAbove(class_1936 world, class_2338 pos, class_2470 rotation) {
        if (this.containsBedrock(world, pos)) {
            return false;
        }
        return (double)this.getAirFractionFoundation(world, pos, rotation) < 0.5 && world.method_8320(pos.method_10086(2)).method_27852(class_2246.field_10124) && world.method_8320(pos.method_10086(4)).method_27852(class_2246.field_10124);
    }

    protected boolean canGenerateFloor(class_1936 world, class_2338 pos, class_2470 rotation) {
        if (this.containsBedrock(world, pos)) {
            return false;
        }
        return (double)this.getAirFraction(world, pos, rotation) > 0.6 && (double)this.getAirFractionFoundation(world, pos, rotation) < 0.5;
    }

    protected boolean canGenerateLava(class_1936 world, class_2338 pos, class_2470 rotation) {
        if (this.containsBedrock(world, pos)) {
            return false;
        }
        return (double)this.getLavaFractionFoundation(world, pos, rotation) > 0.9 && (double)this.getAirFraction(world, pos, rotation) > 0.9;
    }

    protected boolean canGenerateUnder(class_1936 world, class_2338 pos, class_2470 rotation) {
        if (this.containsBedrock(world, pos)) {
            return false;
        }
        return (double)this.getAirFraction(world, pos, rotation) < 0.2;
    }

    protected boolean canGenerateCeil(class_1936 world, class_2338 pos, class_2470 rotation) {
        if (this.containsBedrock(world, pos)) {
            return false;
        }
        return (double)this.getAirFractionBottom(world, pos, rotation) > 0.8 && (double)this.getAirFraction(world, pos, rotation) < 0.6;
    }

    public class_3341 boundingBox(class_2470 r, class_2338 p) {
        return this.getBoundingBox(p, r, class_2415.field_11302);
    }

    protected float getAirFraction(class_1936 world, class_2338 pos, class_2470 rotation) {
        class_2338.class_2339 POS = new class_2338.class_2339();
        int airCount = 0;
        class_2338.class_2339 size = new class_2338.class_2339().method_10101((class_2382)new class_2338(this.structure.method_15160()).method_10070(rotation));
        size.method_33097(Math.abs(size.method_10263()) >> 1);
        size.method_33099(Math.abs(size.method_10260()) >> 1);
        class_2338 start = pos.method_10069(-size.method_10263(), 0, -size.method_10260());
        class_2338 end = pos.method_10069(size.method_10263(), size.method_10264() + this.offsetY, size.method_10260());
        int count = 0;
        for (int x = start.method_10263(); x <= end.method_10263(); ++x) {
            POS.method_33097(x);
            for (int y = start.method_10264(); y <= end.method_10264(); ++y) {
                POS.method_33098(y);
                for (int z = start.method_10260(); z <= end.method_10260(); ++z) {
                    POS.method_33099(z);
                    if (world.method_22347((class_2338)POS)) {
                        ++airCount;
                    }
                    ++count;
                }
            }
        }
        return (float)airCount / (float)count;
    }

    private float getLavaFractionFoundation(class_1936 world, class_2338 pos, class_2470 rotation) {
        class_2338.class_2339 POS = new class_2338.class_2339();
        int lavaCount = 0;
        class_2338.class_2339 size = new class_2338.class_2339().method_10101((class_2382)new class_2338(this.structure.method_15160()).method_10070(rotation));
        size.method_33097(Math.abs(size.method_10263()) >> 1);
        size.method_33099(Math.abs(size.method_10260()) >> 1);
        class_2338 start = pos.method_10069(-size.method_10263(), 0, -size.method_10260());
        class_2338 end = pos.method_10069(size.method_10263(), 0, size.method_10260());
        int count = 0;
        POS.method_33098(pos.method_10264() - 1);
        for (int x = start.method_10263(); x <= end.method_10263(); ++x) {
            POS.method_33097(x);
            for (int z = start.method_10260(); z <= end.method_10260(); ++z) {
                POS.method_33099(z);
                if (BlocksHelper.isLava(world.method_8320((class_2338)POS))) {
                    ++lavaCount;
                }
                ++count;
            }
        }
        return (float)lavaCount / (float)count;
    }

    private float getAirFractionFoundation(class_1936 world, class_2338 pos, class_2470 rotation) {
        class_2338.class_2339 POS = new class_2338.class_2339();
        int airCount = 0;
        class_2338.class_2339 size = new class_2338.class_2339().method_10101((class_2382)new class_2338(this.structure.method_15160()).method_10070(rotation));
        size.method_33097(Math.abs(size.method_10263()) >> 1);
        size.method_33099(Math.abs(size.method_10260()) >> 1);
        class_2338 start = pos.method_10069(-size.method_10263(), -1, -size.method_10260());
        class_2338 end = pos.method_10069(size.method_10263(), 0, size.method_10260());
        int count = 0;
        for (int x = start.method_10263(); x <= end.method_10263(); ++x) {
            POS.method_33097(x);
            for (int y = start.method_10264(); y <= end.method_10264(); ++y) {
                POS.method_33098(y);
                for (int z = start.method_10260(); z <= end.method_10260(); ++z) {
                    POS.method_33099(z);
                    if (world.method_8320((class_2338)POS).method_26207().method_15800()) {
                        ++airCount;
                    }
                    ++count;
                }
            }
        }
        return (float)airCount / (float)count;
    }

    private float getAirFractionBottom(class_1936 world, class_2338 pos, class_2470 rotation) {
        class_2338.class_2339 POS = new class_2338.class_2339();
        int airCount = 0;
        class_2338.class_2339 size = new class_2338.class_2339().method_10101((class_2382)new class_2338(this.structure.method_15160()).method_10070(rotation));
        size.method_33097(Math.abs(size.method_10263()));
        size.method_33099(Math.abs(size.method_10260()));
        float y1 = Math.min(this.offsetY, 0);
        float y2 = Math.max(this.offsetY, 0);
        class_2338 start = pos.method_10080((double)(-(size.method_10263() >> 1)), (double)y1, (double)(-(size.method_10260() >> 1)));
        class_2338 end = pos.method_10080((double)(size.method_10263() >> 1), (double)y2, (double)(size.method_10260() >> 1));
        int count = 0;
        for (int x = start.method_10263(); x <= end.method_10263(); ++x) {
            POS.method_33097(x);
            for (int y = start.method_10264(); y <= end.method_10264(); ++y) {
                POS.method_33098(y);
                for (int z = start.method_10260(); z <= end.method_10260(); ++z) {
                    POS.method_33099(z);
                    if (world.method_8320((class_2338)POS).method_26207().method_15800()) {
                        ++airCount;
                    }
                    ++count;
                }
            }
        }
        return (float)airCount / (float)count;
    }

    public boolean loaded() {
        return this.structure != null;
    }
}

